<?php

    if (!is_user_logged_in()) {
        wp_redirect(home_url());
        exit;
    }
    $file = get_field('download_files');
    $link = get_field('link');

?>

<?php get_header(); ?>

    <main class="px-6 pt-24 pb-8">
        <div class="max-w-7xl mx-auto mb-6">
            <div class="flex items-center space-x-2 text-sm overflow-x-auto scrollbar-hide whitespace-nowrap pb-2" style="scrollbar-width: none; -ms-overflow-style: none;">
                <a href="<?php echo pll_home_url(); ?>" class="text-slate-400 hover:text-white transition-colors flex-shrink-0">
                    <?php pll_e('Головна'); ?>
                </a>
                <span class="text-slate-600 flex-shrink-0">/</span>
                <a href="<?php echo pll_home_url(); ?>cabinet" class="text-slate-400 hover:text-white transition-colors flex-shrink-0">
                    <?php pll_e('Особистий кабінет'); ?>
                </a>
                <span class="text-slate-600 flex-shrink-0">/</span>
                <span class="text-slate-300 flex-shrink-0"><?php the_title(); ?></span>
            </div>
        </div>
        <div class="max-w-7xl mx-auto">
            <?php while (have_posts()) : the_post(); ?>
                <article class="glass-effect rounded-xl p-6">
                    <h1 class="text-3xl font-bold text-white mb-4"><?php the_title(); ?></h1>

                    <div class="flex items-center justify-between mb-4">
                        <?php
                        $categories = get_the_category();
                        if (!empty($categories)) : ?>
                            <span class="bg-red-600 text-white text-sm font-semibold px-3 py-1 rounded">
                            <?php echo esc_html($categories[0]->name); ?>
                        </span>
                        <?php endif;

                        $platforms = get_the_terms(get_the_ID(), 'platform');
                        if (!empty($platforms)) : ?>
                            <span class="bg-blue-600 text-white text-sm font-semibold px-3 py-1 rounded">
                            <?php echo esc_html($platforms[0]->name); ?>
                        </span>
                        <?php endif; ?>
                    </div>

                    <div class="text-slate-400 space-y-6">
                        <?php the_content(); ?>
                    </div>

                    <?php if ($file): ?>
                        <div class="mt-8 border-t border-gray-800 pt-6">
                        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-[300px_1fr] gap-4 items-center">
                                <h3 class="text-xl font-semibold text-white"><?php pll_e('Файл для завантаження'); ?></h3>
                                <a href="<?php echo esc_url($file['url']); ?>"
                                   download="<?php echo esc_attr($file['filename']); ?>"
                                   class="flex items-center space-x-3 p-3 bg-slate-800 rounded-lg hover:bg-slate-700 transition-colors group">
                                    <i class="ri-download-2-line text-xl text-blue-500"></i>
                                    <span class="text-slate-300 group-hover:text-white transition-colors"><?php echo esc_html($file['filename']); ?></span>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($link): ?>
                        <div class="mt-8 border-t border-gray-800 pt-6">
                        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-[300px_1fr] gap-4 items-center">
                                <h3 class="text-xl font-semibold text-white"><?php pll_e('Посилання'); ?></h3>
                                <a href="<?php echo esc_url($link); ?>"
                                    target="_blank"
                                    class="flex items-center space-x-3 p-3 bg-slate-800 rounded-lg hover:bg-slate-700 transition-colors group">
                                    <i class="ri-link text-xl text-blue-500"></i>
                                    <span class="text-slate-300 group-hover:text-white transition-colors">
                                        <?php echo esc_html($link); ?>
                                    </span>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                </article>
            <?php endwhile; ?>
        </div>
    </main>

<?php get_footer(); ?>