document.addEventListener('DOMContentLoaded', function() {
    const languageToggle = document.getElementById('language-toggle');
    const languageDropdown = document.getElementById('language-dropdown');
    const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
    const mobileMenu = document.getElementById('mobile-menu');
    if (languageToggle && languageDropdown) {
        languageToggle.addEventListener('click', function(e) {
            e.stopPropagation();
            languageDropdown.classList.toggle('active');
        });

        document.addEventListener('click', function(e) {
            if (!languageToggle.contains(e.target) && !languageDropdown.contains(e.target)) {
                languageDropdown.classList.remove('active');
            }
        });
    }
    if (mobileMenuToggle) {
        mobileMenuToggle.addEventListener('click', function() {
            mobileMenu.classList.toggle('active');
        });
    }

    const navLinks = document.querySelectorAll('nav a[href^="#"]');
    navLinks.forEach(link => {
        link.addEventListener('click', function() {
            mobileMenu.classList.remove('active');
        });
    });
});
function scrollToPricing() {
    document.getElementById('pricing').scrollIntoView({ behavior: 'smooth' });
}

document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.faq-toggle').forEach(button => {
        button.addEventListener('click', function() {
            const target = this.getAttribute('data-target');
            const answer = document.getElementById(target);
            const icon = this.querySelector('i');

            // Просто переключаем hidden
            if (answer.classList.contains('hidden')) {
                answer.classList.remove('hidden');
                icon.classList.remove('ri-add-line');
                icon.classList.add('ri-subtract-line');
            } else {
                answer.classList.add('hidden');
                icon.classList.remove('ri-subtract-line');
                icon.classList.add('ri-add-line');
            }
        });
    });
});

function openAccessForm() {
    document.getElementById('access-modal').classList.remove('hidden');
    document.getElementById('access-modal').classList.add('flex');
}
function closeAccessForm() {
    document.getElementById('access-modal').classList.add('hidden');
    document.getElementById('access-modal').classList.remove('flex');
}
// function selectPlan(plan) {
//     openAccessForm();
//     const planRadios = document.querySelectorAll('input[name="plan"]');
//     planRadios.forEach(radio => {
//         if (radio.value === plan) {
//             radio.checked = true;
//             radio.closest('label').querySelector('.plan-radio').classList.add('border-primary');
//             radio.closest('label').querySelector('.plan-radio div').classList.remove('hidden');
//         }
//     });
// }

function selectPlan(planValue) {
    openAccessForm();

    setTimeout(() => {
        const radioInputs = document.querySelectorAll('#access-modal input[name="plan"]');

        radioInputs.forEach(input => {
            if (input.value === planValue) {
                input.checked = true;

                // Активируем кастомные стили
                const event = new Event('change', { bubbles: true });
                input.dispatchEvent(event);

                // Также добавляем класс для визуального выделения
                const label = input.closest('.wpcf7-list-item');
                if (label) {
                    // Убираем выделение у всех
                    document.querySelectorAll('.wpcf7-list-item').forEach(item => {
                        item.classList.remove('plan-selected');
                    });
                    // Добавляем выделение выбранному
                    label.classList.add('plan-selected');
                }
            }
        });
    }, 100);
}
function toggleExperienceDropdown() {
    const dropdown = document.getElementById('experience-dropdown');
    dropdown.classList.toggle('hidden');
}
function selectExperience(level) {
    document.getElementById('experience-selected').textContent = level;
    document.getElementById('experience-dropdown').classList.add('hidden');
}
// document.addEventListener('DOMContentLoaded', function() {
//     const planRadios = document.querySelectorAll('input[name="plan"]');
//     planRadios.forEach(radio => {
//         radio.addEventListener('change', function() {
//             document.querySelectorAll('.plan-radio').forEach(item => {
//                 item.classList.remove('border-primary');
//                 item.querySelector('div').classList.add('hidden');
//             });
//             if (this.checked) {
//                 const radioDiv = this.closest('label').querySelector('.plan-radio');
//                 radioDiv.classList.add('border-primary');
//                 radioDiv.querySelector('div').classList.remove('hidden');
//             }
//         });
//     });
// });

// document.addEventListener('DOMContentLoaded', function() {
//     const langUA = document.getElementById('langUA');
//     const langEN = document.getElementById('langEN');
//     langUA.addEventListener('click', function() {
//         langUA.classList.add('bg-primary', 'text-white');
//         langUA.classList.remove('text-slate-300');
//         langEN.classList.remove('bg-primary', 'text-white');
//         langEN.classList.add('text-slate-300');
//     });
//     langEN.addEventListener('click', function() {
//         langEN.classList.add('bg-primary', 'text-white');
//         langEN.classList.remove('text-slate-300');
//         langUA.classList.remove('bg-primary', 'text-white');
//         langUA.classList.add('text-slate-300');
//     });
// });